qui {

noi {
	/************************************************************************************/
	/***** Step 4.1.  Export country-year-specific results */
	/************************************************************************************/
}
	
	* Collect necessary information
	cd ..
	cd ".\4. Master data"
	use master_data_secondstep, clear
	keep cntrycode cntry year independence_years referendum_dummy violent_secession landlocked mother_country_name
	replace cntry = "Lesotho" if cntry == "Basutoland (Lesotho)" // Correct country name
	replace cntry = "Rwanda" if cntry == "Ruanda"				 // Correct country name
	cd ..
	cd "./3. Intermediary results"
	merge 1:1 cntry independence_years using IDD1, keepusing(IDD)
	drop if _merge == 2
	drop _merge
	cd ..
	cd ".\4. Master data"
	replace cntry = "Basutoland (Lesotho)" if cntry == "Lesotho"
	replace cntry = "Ruanda" if cntry == "Rwanda"
	merge 1:1 cntry independence_years year using master_data, keepusing(mother_country_name)
	keep if independence_years == 0
	replace cntry = "Lesotho" if cntry == "Basutoland (Lesotho)" 	// Correct country name
	replace cntry = "Rwanda" if cntry == "Ruanda" 					// Correct country name
	replace cntry = "Serbia" if cntry == "ZzSerbia" 				// Correct country name
	drop if cntry == "Germany" | cntry == "German Democratic Republic" | cntry == "German Federal Republic" | cntry == "Yemen" | cntry == "Ethiopia" | cntry == "San Marino"
	replace mother_country_name = "Yugoslavia" if mother_country_name == "Montenegro" |  mother_country_name == "Serbia"	 					// Correct mother country name
	replace mother_country_name = "United Kingdom" if mother_country_name == "United Arab Emirates" |  mother_country_name == "Oman"			// Correct mother country name
	replace mother_country_name = "United States of America" if mother_country_name == "Palau"													// Correct mother country name
	replace mother_country_name = "Soviet Union" if cntry == "North Korea"																		// Correct mother country name
	replace mother_country_name = "South Africa" if mother_country_name == "Namibia"															// Correct mother country name

	keep cntry year IDD referendum_dummy violent_secession landlocked mother_country_name
	replace cntry =  subinstr(cntry, "&", "\&",.)
	
	* Add information on attributes of NICs
		
		* Identify NICs with independence dividend estimates available
		replace cntry = cntry + "$^{\diamond}$" if IDD != .
		
		* Identify NICs declaring independence by referendum
		replace cntry = cntry + "$^{\star}$" if referendum_dummy == 1
		
		* Identify violent secessions
		replace cntry = cntry + "$^{\bullet}$" if violent_secession == 1
		
		* Identify landlocked countries
		replace cntry = cntry + "$^{\dagger}$" if landlocked == 1
			
		* Identify mother countries
		replace cntry = cntry + "$^{1}$" if mother_country_name == "Belgium"
		replace cntry = cntry + "$^{2}$" if mother_country_name == "Czechoslovakia"
		replace cntry = cntry + "$^{3}$" if mother_country_name == "France"
		replace cntry = cntry + "$^{4}$" if mother_country_name == "Portugal"
		replace cntry = cntry + "$^{5}$" if mother_country_name == "Russia"
		replace cntry = cntry + "$^{6}$" if mother_country_name == "United Kingdom"
		replace cntry = cntry + "$^{7}$" if mother_country_name == "United States of America"
		replace cntry = cntry + "$^{8}$" if mother_country_name == "Yugoslavia"
		replace cntry = cntry + "$^{9}$" if mother_country_name != "Belgium" &  mother_country_name != "Czechoslovakia" &  mother_country_name != "France" &  mother_country_name != "Portugal" &  mother_country_name != "Russia" &  mother_country_name != "United Kingdom" &  mother_country_name != "United States of America" &  mother_country_name != "Yugoslavia"
		
		* Add separator
		replace cntry =  subinstr(cntry, "$$", "$$^{,}$$",.)

	* Export to table A2
	
		* Make the table
		
		sort year cntry
		gen n = _n
		sum year
		local helpme_1 = round(((`r(N)')/3)+1)
		local helpme_2 = round(`r(N)'/3)
		local first_third = ceil(`r(N)'/3)
		local second_third = ceil(`r(N)'/3) * 2 - 1
		gen helpme = 3
		replace helpme = 1 if n <= `first_third'
		replace helpme = 2 if n >  `first_third' & n <= `second_third'
		keep cntry year n helpme
		reshape wide cntry year, i(n) j(helpme)
		gen column = 1 if year1 != .
		replace column = 2 if year2 != .
		replace column = 3 if year3 != .
		drop n
		bysort column: gen n = _n
		collapse (lastnm) year* cntry*, by(n)
		drop n

		* Export it
		order cntry1 year1 cntry2 year2 cntry3 year3
		cd ..
		cd "./5. TeX results"
		listtab ///
		using tableA4.tex,  replace ///
		rstyle(tabular) ///
		headlines("\begin{tabular}{llllll} \\ \toprule \emph{Country} &	\emph{Year} & \emph{Country} &	\emph{Year} & \emph{Country} &	\emph{Year}	\\ \midrule") ///
		footlines("\bottomrule \end{tabular}")

	* Reroute to directory containing dofiles
	cd ..
	cd ".\1. Dofiles"
	}
